import { NextRequest, NextResponse } from "next/server"
import { wgApi } from "@/lib/wg-api"

export async function GET(
  request: NextRequest,
  { params }: { params: Promise<{ id: string }> }
) {
  try {
    const { id } = await params
    const config = await wgApi.getClientConfig(id)
    
    return new NextResponse(config, {
      headers: {
        'Content-Type': 'text/plain',
        'Content-Disposition': `attachment; filename="wg-${id}.conf"`,
      },
    })
  } catch (error) {
    console.error("Error fetching client config:", error)
    const errorMessage = error instanceof Error ? error.message : "Failed to fetch config"
    return NextResponse.json(
      { error: errorMessage },
      { status: 500 }
    )
  }
}

